function Fig1(X1, YMatrix1, YMatrix2)
%CREATEFIGURE(X1, YMatrix1, YMatrix2)
%  X1:  vector of loglog x data
%  YMATRIX1:  matrix of loglog y data
%  YMATRIX2:  matrix of loglog y data

%  Auto-generated by MATLAB on 18-May-2023 13:05:31

% Create figure
figure('WindowState','maximized');

% Create subplot
subplot1 = subplot(2,1,1);
hold(subplot1,'on');

% Create multiple line objects using matrix input to loglog
loglog1 = loglog(X1,YMatrix1,'LineWidth',3.5);
set(loglog1(1),'DisplayName','Upper-bound (30)');
set(loglog1(2),'DisplayName','Upper-bound (32), $\alpha = 3/4$');
set(loglog1(3),'DisplayName','Upper-bound [Laborde et al., [2020]]');

% Create ylabel
ylabel('Bound value for $L=100$','FontSize',30,'Interpreter','latex');

% Create xlabel
xlabel('Iteration');

% Uncomment the following line to preserve the X-limits of the axes
% xlim(subplot1,[9.93829372133691 98160211.1389042]);
% Uncomment the following line to preserve the Y-limits of the axes
% ylim(subplot1,[0.00254014737176336 146.433148119039]);
box(subplot1,'on');
hold(subplot1,'off');
% Set the remaining axes properties
set(subplot1,'FontName','Times New Roman','FontSize',36,'XGrid','on',...
    'XMinorTick','on','XScale','log','YGrid','on','YMinorTick','on','YScale',...
    'log');
% Create legend
legend1 = legend(subplot1,'show');
set(legend1,...
    'Position',[0.556617120175656 0.782703806906428 0.324092158564815 0.130096266231435],...
    'Interpreter','latex');

% Create subplot
subplot2 = subplot(2,1,2);
hold(subplot2,'on');

% Create multiple line objects using matrix input to loglog
loglog2 = loglog(X1,YMatrix2,'LineWidth',3.5);
set(loglog2(1),'DisplayName','Upper-bound (30)');
set(loglog2(2),'DisplayName','Upper-bound (32), $\alpha=3/4$');
set(loglog2(3),'DisplayName','Upper-bound [Laborde et al., [2020]]');

% Create ylabel
ylabel('Bound value for $L=1000$','FontSize',30,'Interpreter','latex');

% Create xlabel
xlabel('Iteration');

% Uncomment the following line to preserve the X-limits of the axes
% xlim(subplot2,[10.0620894093023 100000000]);
% Uncomment the following line to preserve the Y-limits of the axes
% ylim(subplot2,[0.0209106348925822 1441.83267396833]);
box(subplot2,'on');
hold(subplot2,'off');
% Set the remaining axes properties
set(subplot2,'FontName','Times New Roman','FontSize',36,'XGrid','on',...
    'XMinorTick','on','XScale','log','YGrid','on','YMinorTick','on','YScale',...
    'log');
% Create legend
legend2 = legend(subplot2,'show');
set(legend2,...
    'Position',[0.557658786842323 0.308285202255263 0.324092158564815 0.130096266231435],...
    'Interpreter','latex');

